<?php

namespace Beedask\Models;

use Illuminate\Database\Eloquent\Model;

class Comment extends Model 
{

    protected $table = 'comments';
    public $timestamps = true;
    protected $fillable = array('user_id', 'question_id', 'body');
    protected $visible = array('user_id', 'question_id', 'body');

    public function user()
    {
        return $this->belongsTo('User', 'user_id');
    }

    public function question()
    {
        return $this->belongsTo('Question', 'question_id');
    }

}